# Site Mailer - SMTP Replacement, Email API Deliverability & Email Log

**Contributors:** elemntor \
**Tags:** email, email log, SMTP, email API, sender \
**Requires at least:** 6.3 \
**Tested up to:** 6.8 \
**Requires PHP:** 7.4 \
**Stable tag:** 1.3.0 \
**License:** GPL-3 \
**License URI:** https://www.gnu.org/licenses/gpl-3.0.en.html

Effortlessly manage transactional emails with Site Mailer. High deliverability, logs and statistics, and no SMTP plugins needed.

## Description

https://www.youtube.com/watch?v=1hOxkEO-22I

Has your WordPress site stopped sending emails? Are emails from your WordPress site landing in spam or not getting delivered? Are customers complaining about missing messages?

With **Site Mailer**, you can say goodbye to email issues. Our easy-to-use tool ensures all emails reach their destination while providing you with a detailed email log to track and resend messages if needed.

**Enhance your email management effortlessly**. Site Mailer eliminates the need for complex SMTP plugins, providing a streamlined solution for reliable email deliverability. Troubleshoot and monitor with ease using our intuitive interface, so you never miss another email.

## Key Features

### High Deliverability

Ensure your emails consistently reach your audience's inbox with optimized sending methods designed to maximize deliverability and minimize spam risk.

### Use Your Custom Domain

Send emails with your custom domain — or get started quickly with our default email so no email will be lost once you start working with Site Mailer.

### No Integration or SMTP Plugin Needed

Site Mailer works seamlessly without the need for additional API integration or SMTP plugins. This means less hassle and more efficient email management.

### Easy Setup

Get started with Site Mailer in no time. Our intuitive setup process ensures you can configure and start using the plugin quickly and effortlessly.

### 30-Day Log Retention

The plugin includes 30 days of email log retention, allowing you to easily track and review your email activity.

### Compatibility with Popular Plugins

Site Mailer has been tested to be fully compatible with most popular WordPress plugins, including Elementor Pro, WooCommerce, Contact Form 7, WPForms and more.

### Reputation Management

Safeguard your email sending reputation with intelligent features that enhance your sender score, ensuring consistent inbox placement and reducing the risk of emails being marked as spam.

### Email Testing

Send a test email to confirm your site is properly configured for seamless transactional email delivery.

### Resend Failed Emails

Did an email fail to deliver? Easily resend it with a single click to ensure your message reaches its intended recipient.

### Suppression List

Enable easy unsubscribe options for your emails. Track and manage all unsubscribed recipients directly in the Suppressions tab.

== Benefits ==

* **No Integration Needed**: Use Site Mailer without the need for additional plugins or integrations.
* **Troubleshooting**: Efficiently troubleshoot and resend emails when necessary.
* **Spam Reduction**: Our plugin will keep your emails out of the spam folder, ensuring that your important messages reach their intended recipients.
* **Built by the Elementor team**: Leverage the trust and reliability of a solution developed by Elementor.

## Get Started Today

**Transform your website’s email management with Site Mailer!**

For more information about Site Mailer, visit our [official website](https://go.elementor.com/wp-repo-wp-dash-sm-product-page/).
If you have any questions or need support, feel free to [contact us](https://go.elementor.com/wp-repo-wp-dash-sm-contact-us/) or visit our [help center](https://go.elementor.com/wp-repo-wp-dash-sm-help-center/).

This plugin requires a connection to an active Elementor account in order to identify the user and provide the user with the purchased service. This connection is triggered manually by the user via the plugin's settings panel. Learn more our [terms and conditions](https://go.elementor.com/wp-repo-wp-dash-sm-term-and-conditions/).

This plugin uses a 3rd party service operated by Elementor, which accepts Email information including but not limited to (from, to, cc,bcc addresses, email body, subject line and attachments). This flow is triggered automatically on every email sending process utilizing the native WordPress `wp_mail` function.

## Related Plugins

[Image Optimizer](https://wordpress.org/plugins/image-optimization/): Superior image compression for faster, high-quality website performance.

## Installation

**Get started with a few easy steps**

1. Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in the wp-content/plugins/ directory of your WordPress installation.
2. Activate the plugin through the ‘Plugins’ menu in WordPress.
3. Go to the Site Mailer tab within the Settings menu.
4. Press the ‘Connect’ button and follow the instructions.

## Frequently Asked Questions

### How does the Site Mailer plugin work?

The Site Mailer plugin connects your site to our secure email service, allowing you to send transactional emails through the cloud instead of your server. This ensures higher deliverability, enhanced security, and better email management.

### Does the plugin work with all types of hosting providers?

Yes, the Site Mailer plugin works with all types of hosting providers, as it connects your site to our secure email service via the cloud, ensuring compatibility regardless of your hosting environment.

### Can I use the Site Mailer plugin if I'm not tech-savvy?

Absolutely! The Site Mailer plugin is designed to be user-friendly, with a simple setup process and an intuitive interface, making it easy to use even if you’re not tech-savvy. Just install and activate the plugin, and your emails will automatically be sent through our service.

### Why do I need a plugin when I have my regular Hypertext Preprocessor (PHP) mail() function?

Using the PHP mail() function can cause issues with email deliverability and security. The Site Mailer plugin offers several benefits:
* Higher Deliverability: Emails are less likely to be marked as spam.
* Enhanced Security: Uses secure authentication methods.
* Logs and Monitoring: Provides detailed logs and monitoring for better email management.
* Overall, it ensures your transactional emails are sent reliably and professionally.

### Do you offer support?

Yes, the Elementor team offers full support for Site Mailer questions. You can contact us via our [Contact Page](https://go.elementor.com/wp-repo-wp-dash-sm-contact-us/)

### How can I report security bugs?

You can report security bugs through the Patchstack Vulnerability Disclosure Program. The Patchstack team help validate, triage and handle any security vulnerabilities. [Report a security vulnerability](https://patchstack.com/database/vdp/site-mailer).

## Screenshots

### 1. Dashboard – Email sending activity, including total emails sent, delivery and open rates, and failed emails.

![Dashboard – Email sending activity, including total emails sent, delivery and open rates, and failed emails.](https://ps.w.org/site-mailer/assets/screenshot-1.png)

### 2. Email setup complete in one click – Your site is now ready to send emails using a default sender.

![Email setup complete in one click – Your site is now ready to send emails using a default sender.](https://ps.w.org/site-mailer/assets/screenshot-2.png)

### 3. Settings- configure your sender details. You can add a custom domain, send test emails, and save content for future resends.

![Settings- configure your sender details. You can add a custom domain, send test emails, and save content for future resends.](https://ps.w.org/site-mailer/assets/screenshot-3.png)

### 4. Custom Domain Authentication Wizard - Guides you through adding a custom domain.

![Custom Domain Authentication Wizard - Guides you through adding a custom domain.](https://ps.w.org/site-mailer/assets/screenshot-4.png)

### 5. Custom Domain Authentication Wizard - Guides you through adding a custom domain with DNS settings.

![Custom Domain Authentication Wizard - Guides you through adding a custom domain with DNS settings.](https://ps.w.org/site-mailer/assets/screenshot-5.png)


## Changelog

### 1.3.0 - 2024-11-04

* Tweak: Improved the Reviews component flow
* Fix: Resolved toast review notification issue

### 1.2.9 - 2025-09-16

* New: Subscription renewal notice
* Fix: Corrected misleading trial quota renewal notice

### 1.2.8 - 2025-08-19

* New: Bulk resend emails
* Tweak: Added feedback questionnaire shown during plugin deactivation
* Tweak: Ensured compatibility with PHP version 8.4

### 1.2.7 - 2025-06-16

* Tweak: Delayed translation loading to improve performance
* Fix: Quota labeling for trial
* Fix: Translations were not loading

### 1.2.6 - 2025-05-29

* Tweak: RTL Support for "What's New"
* Fix: Quota labeling for trial

### 1.2.5 - 2025-05-06

* New: Added Walk through video
* New: Added "What's New" section
* New: Added Review flow
* Tweak: Harden connect security
* Fix: URL mismatch flow issues

### 1.2.4 - 2025-02-26

* Tweak: Harden overall security
* Fix: Connection lost in some cases

### 1.2.3 - 2025-02-04

* Fix: Resend not working in some cases

### 1.2.2 - 2025-02-03

* Tweak: Fallback to native `wp_mail` on error
* Fix: Statistics incorrect count when deleting logs
* Fix: Connect refresh token stuck in edge cases
* Fix: Connect mismatch when home url is not site url

### 1.2.1 - 2024-11-28

* Fix: Some strings are not translatable
* Fix: RTL issue in certain scenarios

### 1.2.0 - 2024-11-19

* New: Added support for `List-Unsubscribe` headers
* New: Added suppressions management interface
* New: Added statuses for multiple recipients in email logs
* Tweak: Some logs table UI corrections
* Fix: Settings crashes when the "To" field is null in email logs

### 1.1.0 - 2024-10-22

* Tweak: Refactor settings module for easier maintenance.
* Tweak: Only send if email is valid.
* Tweak: When all emails are delivered statistics donut color is now green.
* Tweak: Refresh data button design and flow improvements.
* Fix: Custom domain sender prefix update not working.
* Fix: Incorrect direction of some components in RTL.
* Fix: Firefox not displaying connect illustration correctly.

### 1.0.1 - 2024-10-08

* New: Connect helper for users that are not connected
* New: Added 100% quota reached notice for admin pages
* Tweak: Improved "Verify Domain" buttons UI
* Tweak: Increase domain character length for more custom domain
* Tweak: Show 80% quota reached notice on settings panel
* Tweak: Improved RTL support
* Fix: Site local time does not match with the email sent time
* Fix: Settings panel Not loading in edge cases
* Fix: Refresh token error and reconnect
* Fix: Support multiple recipients emails

### 1.0.0 - 2024-09-25

* New: Added option to see full email on hover in logs.
* New: Added a popup to show warning when plan data is not available.
* Tweak: Statistics Pie chart labeling.
* Tweak: After connect modal UI spacing.
* Tweak: Plans bar status is now dynamic and show how many emails  are left.
* Tweak: App header logo adjustments.
* Tweak: Strings changes and corrections
* Tweak: Add link to reached 100% banner.
* Tweak: Auto close Custom Domain verification modal on successful verification.
* Tweak: Added “copied" indication when coping DNS records.
* Tweak: Change the "Pending" status to be called "Sending"
* Tweak: Add warning notices when conflicting 3rd party SMTP/Email plugins are active.
* Fix: invalid plugin header in some hosting environments
* Fix: UI jumps when pressing navigating between tabs.
* Fix: Custom domain prefix overriding default sender in edge cases.

### 0.0.1- 2024-09-16

* Initial release
